% Copyright 2015 The MathWorks, Inc.
function changeSitesOrder()
%% DESCRIPTION
% La fonction changeOrderTargetPoint vous permet de changer graphiquement
% l'ordre de visite des sites
%% WORKFLOW
% 
%
% # Lancez la fonction
% # Redfinissez la trajectoire
% # Sauvegardez la trajectoire
%
% Etape 1 : *Lancez la fonction*
% 
%   changeSitesOrder
%
% Vous devriez voir la photo ci-dessous o :
%
%
% * Le point bleu avec le chiffre rouge 0 dsigne la position initiale du
% robot
% * Les ronds oranges reprsentent les sites  visiter
% * Le trait pointill bleu reprsente la trajectoire originelle du robot
%%
% 
% <<matlabDoc/changeSitesOrder_startScreen.jpg>>
% 
% Etape 2 : *Redfinissez la trajectoire*
%
% Cliquez avec le bouton droit de la souris sur un des points orange pour
% dfinir le premier site  faire explorer au robot :
%%
% 
% <<matlabDoc/changeSitesOrder_firstClick.jpg>>
% 
% Cliquez de nouveau avec le bouton droit de la souris pour dterminer le
% prochain site  faire explorer au robot :
%%
% 
% <<matlabDoc/changeSitesOrder_secondClick.jpg>>
% 
% Etape 3 : *Sauvegardez la trajectoire*
%
% Cliquez ensuite sur tous les cercles orange (qui deviennent bleu lorsque
% vous cliquez dessus) pour dfinir votre nouvelle trajectoire :
%%
% 
% <<matlabDoc/changeSitesOrder_allClick.jpg>>
% 
% Cliquez sur la croix dans le coin suprieur droit de la fentre pour
% fermer la fonction. Une boite de dialogue vous demande alors si vous
% voulez sauvegarder la nouvelle trajectoire.
%
% Si vous rpondez par l'affirmative, la nouvelles trajectoire se
% subtituera  l'ancienne en crasant le fichier Sites.M. La prcdante
% version du fichier Sites.m est renomm site.m_ _DATE_ .bak avec _DATE_ la
% date courrante avec le format yyyy *_* mm *_* dd *_* HH *H* MM *M* SS *.*
% FFF *s* (voir la documentation de la fonction *datenum* pour comprendre
% le format) :
%%
% 
% <<matlabDoc/changeSitesOrder_savedScreen.jpg>>
% 

% get the start position
loadRobotParameters;

% Get an instance of SimDisplay (interface used to display robot evolution)
simApp = SimDisplay.getInstance();
set(simApp.Fig, 'CloseRequestFcn', @CloseRequestFcn);

% Load SitesPosition (using the old Sites.m file that will be written
% as result of this function execution)
Sites;

% Add default Trajectory
line([startPos(1);SitesPositions(:,1)],[startPos(2);SitesPositions(:,2)],...
    'Color','b','LineStyle',':','LineWidth',2,'Parent',simApp.TrackView.Axes); %#ok<NODEF>

% Initialize line that will be completed by this function
hline = line(NaN,NaN,'Color','g','LineStyle','--',...
    'LineWidth',4,'Parent',simApp.TrackView.Axes); 

% Display SitesPositions
for idx = 1:size(SitesPositions,1)
    line(SitesPositions(idx,1),SitesPositions(idx,2),'Color','g',...
        'LineStyle','none','Marker','o','MarkerEdgeColor',[1 0 0],...
        'MarkerFaceColor',[1 0.5 0],'MarkerSize',20,...
        'ButtonDownFcn',{@f_clickPosition,simApp},...
        'Parent',simApp.TrackView.Axes);
end
line(startPos(1),startPos(2),'Color','g',...
    'LineStyle','none','Marker','o','MarkerEdgeColor',1-[1 0 0],...
    'MarkerFaceColor',1-[1 0.5 0],'MarkerSize',20,...
    'Parent',simApp.TrackView.Axes); 
text(startPos(1),startPos(2),num2str(0),'Color',[1 0 0],'FontWeight','bold',...
    'FontSize',20,'Parent',simApp.TrackView.Axes);
setappdata(simApp.Fig,'neworder',startPos(:)');

% Save data (original position and new trajectory in figure workspace
setappdata(simApp.Fig,'originalSitesPositions',SitesPositions);
setappdata(simApp.Fig,'newTargetTrajectory',hline);

end

function f_clickPosition(hObject,~,simApp)
% f_clickPosition Callback for click on point

% Get point position (X and Y)
x = get(hObject,'XData');
y = get(hObject,'YData');

% Update order by adding point in list
neworder = [getappdata(simApp.Fig,'neworder') ;x y];
setappdata(simApp.Fig,'neworder',neworder);

% Get trajectory
hline = getappdata(simApp.Fig,'newTargetTrajectory');

% Update trajectory
set(hline,'XData',neworder(:,1),'YData',neworder(:,2));

% Update object color
set(hObject,'MarkerEdgeColor',1-get(hObject,'MarkerEdgeColor'),...
    'MarkerFaceColor',1-get(hObject,'MarkerFaceColor'),'ButtonDownFcn','');

% Display order number on point
text(x,y,num2str(size(neworder,1)-1),'Color',[1 0 0],'FontWeight','bold',...
    'FontSize',20,'Parent',simApp.TrackView.Axes);

end

function fMySave(filename,SitesPositions)
% fMySave Save target in M-file
%

% Get current date
[year,month,day,hour,minute,second] = datevec(now) ;

% Make a copy of the previous target definition file
oldfileName = sprintf('%s_%4d_%02d_%02d_%02dH%02dM%06.3fs.bak',...
    filename ,year,month,day,hour,minute,second );
movefile(filename,oldfileName,'f');

% Open new file for writing
fid = fopen(filename,'wt');
try %#ok<TRYNC>
    
    % Set file header (to write that file is autogenerated and print the
    % date)
    fprintf(fid,'%% File Autogenerate by function %s\n',mfilename);
    fprintf(fid,'%% Date %s\n',datestr(now,'dddd dd mmmm yyyy HH:MM:SS'));
    
    % Write vector SitesPositions with new values
    fprintf(fid,'SitesPositions = single([...\n');
    fprintf(fid,'\t%4.0f,%4.0f;...\n',SitesPositions');
    fprintf(fid,'\t]);');
end

% Close file
fclose(fid);

% Export SitesPositions vector in base workspace
assignin('base','SitesPositions',SitesPositions);

end

function CloseRequestFcn(hObject,~)
% CloseRequestFcn Callback when window is closed

% Get target position (to have the length of the vector = number of targets)
% Get ordered list of targets
originalSitesPositions=getappdata(hObject,'originalSitesPositions');
neworder=getappdata(hObject,'neworder');
neworder(1,:) = [] ;

if length(neworder)==length(originalSitesPositions)
    
    % Ask for confirmation before saving file
    answer = questdlg('Do you want to save the order of targets', ...
        'Saving confirmation', 'Yes', 'No', 'Yes');
    
    if strcmp(answer,'Yes')
        
        % Save new position file
        fMySave(which('Sites.m'),neworder);
                
    end
    
else
    
    % Display a message
    uiwait(msgbox('No data saved'));
    
end

% Delete figure
delete(hObject)

end

