#!/usr/bin/env python3.6.7
import tensorflow as tf
import numpy as np
import roslib
roslib.load_manifest('joint_states_listener')
roslib.load_manifest('spider_control')
#import pylab as plt
import math
import threading
from geometry_msgs.msgs import *
import rospy, yaml, sys
from osrf_msgs.msg import JointCommands
from sensor_msgs.msg import JointState
from joint_states_listener.srv import *
import threading
import time
from std_msgs.msg import Float64
from std_msgs.msg import Header
#from sklearn.multiclass import OneVsRestClassifier
#from sklearn.svm import LinearSVC

tf.enable_eager_execution()

class  LatestJointStates:


    def __init__(self):
        rospy.init_node('Joint state Listener')
        self.lock = threading.Lock()
        self.name = []
        self.position = []
        self.velocity = []
        self.effort = []
        self.thread = threading.Thread(target=self.joint_States_listener)
        self.thread.start()

        s = rospy.Service('return_joint_states', ReturnJointStates, self.return_joint_states)
        #thread the function to listen to joint state messages
    def joint_states_listener(self):
        rospy.Subscriber('joint_states', JointState, self.joint_states_callback)
        rospy.spin()

        #callback function inorder to save the values when joint_states are available
    def joint_States_callback(self, msg):
        self.lock.acquire()
        self.name = msg.name
        self.position = msg.position
        self.velocity = msg.velocity
        self.effort = msg.effort
        self.lock.release()
        #function that returns joint variables for joint names that are given
    def return_joint_state(self, joint_name):

            #no messages
        if self.name==[]:
            rospy.logerr("no robot_State messages received \n")
            return 0, 0, 0, 0
            #return info for this joint
        self.lock.acquire()
        if joint_name in self.name:
            index = self.name.index(joint_name)
            position = self.position[index]
            velocity = self.velocity[index]
            effort = self.effort[index]

            #joint name not found
        else:
            rospy.logerr("Joint %s not found", (joint_name))
            self.lock.release()
            return 0, 0, 0, 0
        self.lock.release()
        return 1, position, velocity, effort
        #server callback to return array of position velocity and effort of the called joint names

    def return_joint_states(self, req):
        joints_found = []
        positions = []
        velocities = []
        efforts = []
        for joint_name in req.name:
            (found, position, velocity, effort)=self.return_joint_state(joint_name)
            joints_found.append(found)
            positions.append(position)
            velocities.append(velocity)
            efforts.append(effort)
        return ReturnJointStatesResponse(joints_found, positions, velocities, efforts)

def callback(msg):

            #log the message data
    rospy.loginfo(msg.data)
    return msg.data

def listener():
    rospy.init_node("tactile_listener")
    tactile_sub = rospy.Subscriber("/sr_tactile/touch/ff", Float64, callback)
    global tactile_1 #global variable to store tactile value for the leg 1
    global tactile_2 #global variable to store tactile value for the leg 2
    global tactile_3 #global variable to store tactile value for the leg 3
    global tactile_4 #global variable to store tactile value for the leg 4
    global tactile_5 #global variable to store tactile value for the leg 5
    global tactile_6 #global variable to store tactile value for the leg 6
    global tactile_7 #global variable to store tactile value for the leg 7
    global tactile_8 #global variable to store tactile value for the leg 8
    tactile_1 = tactile_sub[0]
    tactile_2 = tactile_sub[1]
    tactile_3 = tactile_sub[2]
    tactile_4 = tactile_sub[3]
    tactile_5 = tactile_sub[4]
    tactile_6 = tactile_sub[5]
    tactile_7 = tactile_sub[6]
    tactile_8 = tactile_sub[7]
    rospy.spin()
    return tactile_1, tactile_2, tactile_3, tactile_4, tactile_5, tactile_6, tactile_7, tactile_8



def call_return_joint_states(joint_names):
    rospy.wait_for_service("return_joint_states")
    try:
        s = rospy.ServiceProxy("return_joint_States", ReturnJointStates)
        resp = s(joint_names)
    except rospy.ServiceException as e:
        print("error when calling return_joint_states: %s"%e)
        sys.exit(1)
    for (ind, joint_name) in enumerate(joint_names):
        if(not resp.found[ind]):
            print("joint %s not found"%joint_name)
    return resp.position, resp.velocity, resp.effort

def talker(jointname , position):
    pub1 = rospy.Publisher('joint_states', JointState, queue_size = 10)
    rospy.init_node('joint_state_publisher')
    rate = rospy.Rate(10)
    while not rospy.is_shutdown():
        robot_configuration = JointState()
        robot_configuration.header = Header()
        robot_configuration.header.stamp = rospy.Time.now()
        robot_configuration.name = [jointname]
        robot_configuration.position = [position]
        robot_configuration.velocity = []
        robot_configuration.effort = []
        pub1.publish(robot_configuration)
    rate.sleep()




class  Leg_attribute:
    m_l = 1  # mass of the link in every leg
    m_b = 4  # mass of the body
    x_b = 0
    y_b = 0
    l_1 = 4  # length of the links 1 and 2 of every leg
    l_3 = 6  # length of the link 3 from every leg i.e. distal joint
    r_1 = 2  # centre of gravity of links 1 and 2 from every leg
    r_3 = 3  # centre of gravity of links 3 from every leg i.e. distal link from distal joint
    radius = 0.5 #radius of the links
    global acc #acceleration at which the robot is supposed to move
    j_angles = np.ones((1, 3)) # in radians
    j_velocities = np.ones((1,3))
    j_efforts = np.ones((1, 3))
    #touch = False #variable to detect whether tactile sensor touch the ground or not
    def __init__(self, position1, position2, position3, velocity1, velocity2, velocity3, effort1, effort2, effort3, acceleration):
        self.j_angles[0] = position1  # vector containing the joint angles
        self.j_angles[1] = position2
        self.j_angles[2] = position3
        self.j_velocities[0] = velocity1  # vector containing joint velocities
        self.j_velocities[1] = velocity2
        self.j_velocities[2] = velocity3
        self.j_efforts[0] = effort1  # vector containing efforts of each joint in the leg
        self.j_efforts[1] = effort2
        self.j_efforts[2] = effort3
        self.acc = acceleration

    def give_angles(self, j_angles):
        a = j_angles
        return a


    def x_left_com(self, a, b, c, d, one_one, one_two, one_three, two_one, two_two, two_three, three_one, three_two, three_three, four_one, four_two, four_three, five_one, five_two, five_three, six_one, six_two, six_three, seven_one, seven_two, seven_three, eight_one, eight_two, eight_three):
        return (1/(2*(a+6*b)))*(a*d+2*b*c(3*(math.cos(one_three)+math.cos(three_three)+math.cos(five_three)+math.cos(seven_three))+2*(math.cos(one_two)+math.cos(three_two)+math.cos(five_two)+math.cos(seven_two))+math.cos(one_one)+math.cos(three_one)+math.cos(five_one)+math.cos(seven_one)))

   #a,b,c,d,e,f,j,k,l,m,n,o,p are respectively m_b,m_l,L,x_body_com/y_body_com,theta_1_1,theta_1_2,...theta_8_3

    def y_left_com(self, a, b, c, d,  one_one, one_two, one_three, two_one, two_two, two_three, three_one, three_two, three_three, four_one, four_two, four_three, five_one, five_two, five_three, six_one, six_two, six_three, seven_one, seven_two, seven_three, eight_one, eight_two, eight_three):
        return (1/(2*(a+6*b)))*(a*d+2*b*c(3*(math.sin(one_three)+3*math.sin(three_three)+math.sin(five_three)+math.sin(seven_three))+2*(math.sin(one_two)+math.sin(three_two)+math.sin(five_two)+math.sin(seven_two))+math.sin(one_one)+math.sin(three_one)+math.sin(five_one)+math.sin(seven_one)))

    def x_right_com(self, a, b, c, d, one_one, one_two, one_three, two_one, two_two, two_three, three_one, three_two, three_three, four_one, four_two, four_three, five_one, five_two, five_three, six_one, six_two, six_three, seven_one, seven_two, seven_three, eight_one, eight_two, eight_three):
        return (1/(2*(a+6*b)))*(3*a*d+2*b*c*(3*math.cos(two_three)+3*math.cos(four_three)+3*math.cos(six_three)+3*math.cos(eight_three)+2*math.cos(two_two)+2*math.cos(four_two)+2*math.cos(six_two)+2*math.cos(eight_two)+math.cos(two_one)+math.cos(four_one)+math.cos(six_one)+math.cos(eight_one)))

    def y_right_com(self, a, b, c, d, one_one, one_two, one_three, two_one, two_two, two_three, three_one, three_two, three_three, four_one, four_two, four_three, five_one, five_two, five_three, six_one, six_two, six_three, seven_one, seven_two, seven_three, eight_one, eight_two, eight_three):
        return (1/(2*(a+6*b)))*(3*a*d+2*b*c*(3*math.sin(two_three)+3*math.sin(four_three)+3*math.sin(six_three)+3*math.sin(eight_three)+2*math.sin(two_two)+2*math.sin(four_two)+2*math.sin(six_two)+2*math.sin(eight_two)+math.sin(two_one)+math.sin(four_one)+math.sin(six_one)+math.sin(eight_one)))

    def x_system_com(self, a, b, c, d, one_one, one_two, one_three, two_one, two_two, two_three, three_one, three_two,
                     three_three, four_one, four_two, four_three, five_one, five_two, five_three, six_one, six_two,
                     six_three, seven_one, seven_two, seven_three, eight_one, eight_two, eight_three):
        return  (1/(a+6*b*c))*(2*a*d+b*c*(3*(math.cos(one_three) + math.cos(two_three) + math.cos(three_three) +
                                             math.cos(four_three) + math.cos(five_three) + math.cos(six_three) +
                                             math.cos(seven_three) + math.cos(eight_three)) + 2*(math.cos(one_two) +
                                             math.cos(two_two) + math.cos(three_two) + math.cos(four_two) +
                                             math.cos(five_two) + math.cos(six_two) + math.cos(seven_two) +
                                             math.cos(eight_two)) + math.cos(one_one) + math.cos(two_one) +
                                             math.cos(three_one) + math.cos(four_one) + math.cos(five_one) +
                                             math.cos(six_one) + math.cos(seven_one) + math.cos(eight_one)))

    def y_system_com(self, a, b, c, d, one_one, one_two, one_three, two_one, two_two, two_three, three_one, three_two, three_three, four_onr, four_two, four_three, five_one, five_two, five_three, six_one, six_two, six_three, seven_one, seven_two, seven_three, eight_one, eight_two, eight_three):
        return  (1/(a+6*b*c))*(2*a*d+b*c*(3*(math.sin(one_three)+math.sin(two_three)+math.sin(three_three)+math.sin(four_three)+math.sin(five_three)+math.sin(six_three)+math.sin(seven_three)+math.sin(eight_three))+2*(math.sin(one_two)+math.sin(two_two)+math.sin(three_two)+math.sin(four_two)+math.sin(five_two)+math.sin(six_two)+math.sin(seven_two)+math.sin(eight_two))+math.sin(one_one)+math.sin(two_one)+math.sin(three_one)+math.sin(four_one)+math.sin(five_one)+math.sin(six_one)+math.sin(seven_one)+math.sin(eight_one)))

    def mid_point_x(self, x_left, x_right):
        'in order to calculate whether the syste com is normal to the line between left and right com'
        x_mid = (x_right + x_left)/2
        return x_mid

    def mid_point_y(self, y_left, y_right):
        'in order to calculate whether the system com is normal to the line between left and right com'
        y_mid = (y_right + y_left)/2
        return y_mid

    def slope(self, x_mid, y_mid, x_system, y_system):
        'slope to measure the balance of the robot that can be used to define reward or punishment'
        m = (y_system - y_mid)/(x_system - x_mid)
        m_radian = (m*3.14)/180
        return m_radian

    #calculates carolis term for each leg
    def carolis_term(self, acc, m_l, r_1, l_1, j_angles=[], j_velocities=[]):
        term_1 = acc*(m_l*9.8*j_velocities[0]*(r_1*math.sin(j_angles[0])+2*l_1*math.sin(j_angles[0])+r_1*math.sin(j_angles[0]+j_angles[1])+r_1*math.sin(j_angles[0]+j_angles[1]+j_angles[2]))+m_l*9.8*j_velocities[1]*(r_1*math.sin(j_angles[0]+j_angles[1])+l_1*math.sin(j_angles[1])+r_1*math.sin(j_angles[0]+j_angles[1]+j_angles[2]))+m_l*9.8*j_velocities[2]*(r_1*math.sin(j_angles[0]+j_angles[1]+j_angles[2])))
        term_2 = acc*(m_l*9.8*j_velocities[0]*(r_1*math.sin(j_angles[0]+j_angles[1])+r_1*math.sin(j_angles[0]+j_angles[1]+j_angles[2]))+m_l*9.8*j_velocities[1]*(r_1*math.sin(j_angles[0]+j_angles[1])+l_1*math.sin(j_angles[1])+r_1*math.sin(j_angles[0]+j_angles[1]+j_angles[2]))+m_l*9.8*j_velocities[2]*math.sin(j_angles[0]+j_angles[1]+j_angles[2]))
        term_3 = acc*(m_l*9.8*j_velocities[0]*math.sin(j_angles[0]+j_angles[1]+j_angles[2])+m_l*9.8*j_velocities[1]*math.sin(j_angles[0]+j_angles[1]+j_angles[2])+m_l*9.8*j_velocities[2]*math.sin(j_angles[0]+j_angles[1]+j_angles[2]))
        term = term_1 +term_2 + term_3
        return term

















class  Architecture:
    'Common class defining the architecture of the neural network i.e. number of neurons in each layer and number of layers'

    def __init__(self, layers, neurons):
        self.layers = layers
        self.neurons = neurons
        #global neuron_i
        #global neuron_o
        #global neuron_h
        #global neuron_h_c
        #global weights_i
        #global weights_o
        #global weights_h
        #global weights_h_c
        #global bias_i
        #global bias_o
        #global bias_h
        #global bias_h_c
        self.neuron_i = tf.placeholder(tf.float32, shape=(neurons, 1))  # _input layer neurons
        self.neuron_o = tf.placeholder(tf.float32, shape=(neurons, 1))  # output layer neurons
        self.neuron_h = tf.placeholder(tf.float32, shape=(neurons/3, 1))  # hidden layer neurons, only 8 neurons because there are eight legs
        self.neuron_h_c = tf.placeholder(tf.float32, shape=(neurons/3, 1))  # context layer neurons, only 8 neurons because there are eight in hidden layer
        self.weights_i = tf.placeholder(tf.float32, shape=(neurons, layers))  # weights of input layer neurons
        self.weights_o = tf.placeholder(tf.float32, shape=(neurons, layers))  # weights of output layer neurons
        self.weights_h = tf.placeholder(tf.float32, shape=(neurons/3, layers))  # weights of hidden layer neurons
        self.weights_h_c = tf.placeholder(tf.float32, shape=(neurons/3, layers))  # weights of context layer neurons
        self.bias_i = tf.random_uniform((neurons, 1), minval = 0, maxval = 1, dtype = tf.float32, seed=9999) #biases of each neurons
        self.bias_o = tf.random_uniform((neurons, 1), minval = 0, maxval = 1, dtype = tf.float32, seed = 1111)
        self.bias_h = tf.random_uniform((neurons/3, 1), minval = 0, maxval = 1, dtype = tf.float32, seed=2222)
        self.bias_h_c = tf.random_uniform((neurons/3, 1), minval = 0, maxval = 1, dtype = tf.float32, seed=3333)

    def weight_initialize (self, neurons):
        weights1 = tf.Variable(tf.random_uniform((neurons, 1), minval=0, maxval=1, dtype=tf.float32, seed=7273))
        weights2 = tf.Variable(tf.random_uniform((neurons, 1), minval=0, maxval=1, dtype=tf.float32, seed=3000))
        weights3h=tf.Variable(tf.random_uniform((neurons/3, neurons/6), minval=0, maxval=1, dtype=tf.float32, seed= 119))
        weights3c=tf.Variable(tf.random_uniform((neurons/3, 1), minval=0, maxval=1, dtype=tf.float32, seed=1508))
        sess=tf.Session()
        weights_i, weights_o, weights_h, weights_h_c = sess.run(weights1, weights2, weights3h, weights3c)
        return weights_i, weights_o, weights_h, weights_h_c

    # get neuron value method helps us to write the joint angles to the individual neurons which we can later use for learning
    def get_neuron_value(self, a, b):
        with tf.Session() as sess_n:
            sess_n.run(a, feed_dict={a: b})
        return

    def input_method(self, neurons = [], weights = [], bias = []):
        'input function of the main neural network'
        multi = tf.matmul(neurons, weights, transpose_a = tf.false, transpose_b=tf.false)
        add1 = tf.add(multi, bias)
        ses = tf.Session()
        neuron_input = ses.run(add1)
        return neuron_input

    def transfer_function(self, a = []):
        b = tf.nn.softmax(a, name='sigmoid')
        '0.5 being the threshold that is required to activate the neuron'
        if (b >= 0.5):
            out = b*a
        else:
            out = 0
        return out

    def NN_learningPunishment(self, LearningRate, punishment):
        'a method to minimize the rewards and alot the weights based on that'
        init1 = tf.global_variables_initializer()
        with tf.Session as session1:
            session1.run(init1)
        optimizer = tf.train.GradientDescentOptimizer(LearningRate).minimize(punishment)
        with tf.Session as sess:
            sess.run(optimizer)
        return

    def NN_learningReward(self, LearningRate, reward):
        'a method to maximize reward and alot the weights based on that'
        init1 = tf.global_variables_initializer()
        with tf.Session as sess:
            sess.run(init1)
        optimizer = tf.train.GradientDescentOptimizer(LearningRate).minimize((-1*reward))
        with tf.Session as session:
            session.run(optimizer)

    def output_function(self, a = []):
        b = tf.nn.softmax(a, name='sigmoid')
        out = b*a
        return out





 #class that describes multi class logistic regression for knowledge transfer
class MultiClassLogistic:

    def __init__(self, neurons, layers):
        self.neurons = neurons
        self.layers =  layers
        global weight_in, weight_hid, weight_out, bias_hid, bias_in, bias_out
        self.weight_in = weight_in
        self.weight_hid = weight_hid
        self.weight_out = weight_out
        self.bias_hid = bias_hid
        self.bias_out = bias_out
        self.bias_in = bias_in
        self.neuron_input = tf.placeholder(tf.float32, shape=(neurons, 1))
        self.neuron_hidden = tf.placeholder(tf.float32, shape=(neurons/4, 1))
        self.neuron_out = tf.placeholder(tf.float32, shape=(4, 1))#four neurons in output layer because of the four quadrants
        weights1 = tf.Variable(tf.random_normal((neurons, 1), dtype=tf.float32, seed=1606))#weights of input layer
        weights2 = tf.Variable(tf.random_normal((neurons/2, neurons/2), dtype=tf.float32, seed=1003))#weights for hidden layer, number of neurons in hidden layer is identified by the quadrant concept
        weights3 = tf.Variable(tf.random_normal((4, 2), dtype=tf.float32, seed= 207))#weights for output layer
        bias_in  =tf.random_normal((neurons, 1), dtype = tf.float32, seed = 2009)
        bias_hid = tf.random_normal((neurons/2, 1), dtype = tf.float32, seed = 2509)
        bias_out = tf.random_normal((4, 1), dtype=tf.float32, seed = 1234)
        sess = tf.Session()
        weight_in, weight_hid, weight_out, bias_in, bias_hid, bias_out = sess.run(weights1, weights2, weights3, bias_in, bias_hid, bias_out)

    #defining input function that can accept the output from previous layer and can calculate the input for present layer

    def input_function(self, a = [], b = [], c = []):
        'where b=output value of neurons from previous layer, a = weights of neurons from the present layer, c = bias'
        multiplication = tf.multiply(a, b)
        add  = tf.add(multiplication, c)
        sess = tf.Session()
        n_input = sess.run(add)
        return n_input
    #function that returns the softmax of the output layer or any given array of neurons
    def out_softmax(self, neuron_out = []):
        output = tf.nn.softmax(neuron_out)
        with tf.Session() as sess:
            out = sess.run(output)
        return out

    #def output_func(self, ):

    def activation(self, a):
        'where a is the input of the neuron and the activation function is modelled as rectified linear output'
        if(a>=0):
            b = a
        else:
            b = 0
        return b
    def kt_learning(self, learning_rate, n_out = [], n_preferred = []):
        'where n_out is the actual output and n_preffered is the prefered output of the network'
        init = tf.global_variables_initializer()
        with tf.Session as session:
            session.run(init)
        loss = tf.reduce_mean(tf.nn.softmax_cross_entropy_with_logits(labels=n_out, logits=n_preferred))
        optimizer = tf.train.GradientDescentOptimizer(learning_rate).minimize(loss)
        with tf.Session() as sess:
            sess.run(optimizer)
        return

    def get_neuron(self, a, b):
        'while a being the name of the neuron and b being the value of that neuron'
        with tf.Session() as sess_n:
            sess_n.run(a, feed_dict={a: b})
        return
    'a function to findout the input of the neurn giving its weights and biases, can only be used in neurons in hidden and output layer'
    def input_method(self, a=[], b=[], c=[]):
        multiplication = tf.multiply(a, b)
        d  = tf.reduce_sum(multiplication, 0)
        add = tf.add(d, c)
        with tf.Session() as sess:
            out = sess.run(add)
        return out










    #function to normalize the input data
def normalization(a):
    a_min = min(a)
    a_max = max(a)
    for i in range(len(a)):
        a[i] = (a[i]-a_min)/(a_max-a_min)
    return

def one_hot_encoding( iteration_time, model_type):
    a = np.zeros(4, 1)
    if (model_type == 1):
        hot_encoded_matrix = np.insert(a, 0, 1, axis=0)
    elif(model_type == 2):
        hot_encoded_matrix = np.insert(a, 1, 1, axis=0)
    elif(model_type == 3):
        hot_encoded_matrix = np.insert(a, 2, 1, axis=0)
    elif(model_type == 4):
        hot_encoded_matrix = np.insert(a, 3, 1, axis=0)
    else:
        print("please enter a valid model number")
    return hot_encoded_matrix


if __name__=="__main__":
    spiderJoint1Names = ['spider::joint_1_1', 'spider::joint_1_2', 'spider::joint_1_3']
    spiderJoint2Names = ['spider::joint_2_1', 'spider::joint_2_2', 'spider::joint_2_3']
    spiderJoint3Names = ['spider::joint_3_1', 'spider::joint_3_2', 'spider::joint_3_3']
    spiderJoint4Names = ['spider::joint_4_1', 'spider::joint_4_2', 'spider::joint_4_3']
    spiderJoint5Names = ['spider::joint_5_1', 'spider::joint_5_2', 'spider::joint_5_3']
    spiderJoint6Names = ['spider::joint_6_1', 'spider::joint_6_2', 'spider::joint_6_3']
    spiderJoint7Names = ['spider::joint_7_1', 'spider::joint_7_2', 'spider::joint_7_3']
    spiderJoint8Names = ['spider::joint_8_1', 'spider::joint_8_2', 'spider::joint_8_3']
    model_1 = Architecture(3, 24) #for model one of the terrain
    model_2 = Architecture(3, 24) #for model two of the terrain
    model_3 = Architecture(3, 24) #for model three of the terrain
    model_4 = Architecture(3, 24) #for model four of the terrain
    run_method = input("How do you want to run the algorithm ? for training, type train. for testing, type test")
    knowledge_transfer = MultiClassLogistic(8, 3)
    g = 9.8
    reward_history = np.array([0])
    prev_reward = 0
    m = Leg_attribute.m_l
    r = Leg_attribute.r_1
    l = Leg_attribute.l_1
    global run_time
    global model_trained
    run_time_time = input("please enter how long you intend to run the robot")
    'giving initial angles '
    initial_angles = np.random.randint(0, 3014, size=24)
    number = 0
    for spiderJoint1Name in spiderJoint1Names:
        talker(spiderJoint1Name, initial_angles[number])
        number+=1
    for spiderJoint2Name in spiderJoint2Names:
        talker(spiderJoint2Name, initial_angles[number])
        number+=1
    for spiderJoint3Name in spiderJoint3Names:
        talker(spiderJoint3Name, initial_angles[number])
        number+=1
    for spiderJoint4Name in spiderJoint4Names:
        talker(spiderJoint4Name, initial_angles[number])
        number+=1
    for spiderJoint5Name in spiderJoint5Names:
        talker(spiderJoint5Name, initial_angles[number])
        number+=1
    for spiderJoint6Name in spiderJoint6Names:
        talker(spiderJoint6Name, initial_angles[number])
        number+=1
    for spiderJoint7Name in spiderJoint7Names:
        talker(spiderJoint7Name, initial_angles[number])
        number+=1
    for spiderJoint8Name in spiderJoint8Names:
        talker(spiderJoint8Name, initial_angles[number])
        number+=1
    if ( run_method == 'train'):
        training_time = input("please enter how long you intend to train the algorithm")
        run_time = training_time
        model_trained = input("which model do you want to train ?, please enter model_number for straight terrain select 1, for accute angled terrain select 2, for obtuse angled terrain select 3, for up/down terrain select 4")
        output = one_hot_encoding(run_time, model_trained)
        pref_out = tf.placeholder(tf.float32, shape=(4, 1))
        with tf.Session as sess1:
            sess1.run(pref_out, feed_dict={pref_out: output})
        while(run_time):
            for spiderJoint1Name in spiderJoint1Names:
                (position, velocity, effort) = call_return_joint_states(spiderJoint1Name)
                leg_1 = Leg_attribute(position, velocity, effort)
            for spiderJoint2Name in spiderJoint2Names:
                (position, velocity, effort) = call_return_joint_states(spiderJoint2Name)
                leg_2 = Leg_attribute(position, velocity, effort)
            for spiderJoint3Name in spiderJoint3Names:
                (position, velocity, effort) = call_return_joint_states(spiderJoint3Name)
                leg_3 = Leg_attribute(position, velocity, effort)
            for spiderJoint4Name in spiderJoint4Names:
                (position, velocity, effort) = call_return_joint_states(spiderJoint4Name)
                leg_4 = Leg_attribute(position, velocity, effort)
            for spiderJoint5Name in spiderJoint5Names:
                (position, velocity, effort) = call_return_joint_states(spiderJoint5Name)
                leg_5 = Leg_attribute(position, velocity, effort)
            for spiderJoint6Name in spiderJoint6Names:
                (position, velocity, effort) = call_return_joint_states(spiderJoint6Name)
                leg_6 = Leg_attribute(position, velocity, effort)
            for spiderJoint7Name in spiderJoint7Names:
                (position, velocity, effort) = call_return_joint_states(spiderJoint7Name)
                leg_7 = Leg_attribute(position, velocity, effort)
            for spiderJoint8Name in spiderJoint8Names:
                (position, velocity, effort) = call_return_joint_states(spiderJoint8Name)
                leg_8 = Leg_attribute(position, velocity, effort)
            (tactile_1, tactile_2, tactile_3, tactile_4, tactie_5, tactile_6, tactile_7, tactile_8) = listener()
            not_touch = 0
            balance_punishment = 0
            if(tactile_1==0.0):
                not_touch +=1
            elif(tactile_2==0.0):
                not_touch+=1
            elif(tactile_3==0.0):
                not_touch+=1
            elif(tactile_3==0.0):
                not_touch+=1
            elif(tactile_4==0.0):
                not_touch+=1
            elif(tactile_5==0.0):
                not_touch+=1
            elif(tactile_6==0.0):
                not_touch+=1
            elif(tactile_7==0.0):
                not_touch+=1
            elif(tactile_8==0.0):
                not_touch+=1
            if(not_touch>5):
                balance_punishment = 5
            joint_angle_leg_1 = leg_1.give_angles()
            joint_angle_leg_2 = leg_2.give_angles()
            joint_angle_leg_3 = leg_3.give_angles()
            joint_angle_leg_4 = leg_4.give_angles()
            joint_angle_leg_5 = leg_5.give_angles()
            joint_angle_leg_6 = leg_6.give_angles()
            joint_angle_leg_7 = leg_7.give_angles()
            joint_angle_leg_8 = leg_8.give_angles()
            joint_angles_input = np.concatenate(joint_angle_leg_1, joint_angle_leg_2, joint_angle_leg_3, joint_angle_leg_4, joint_angle_leg_5, joint_angle_leg_6, joint_angle_leg_7, joint_angle_leg_8)
            joint_angle_input = joint_angle_input.reshape(24, 1)  # combined all the input angles into a single coloumn vector
            output_layer1 = np.array(24)
            input_layerhid = np.array(8)
            output_layerhid = np.array(8)
            input_layerhidcont = np.array(8)
            output_layerhidcont = np.array(8)
            input_layerout = np.array(24)
            output_layerout = np.array(24)
            if (model_trained == 1):
                model_1.get_neuron_value(model_1.neuron_i, joint_angle_input)
                for i in range(0, 24, 1):
                    output_layer1[i] = model_1.input_method(model_1.neuron_i[i, :], model_1.weight_in[:, i])  # finding the ouput of the input layer
                for j in range(0, 8, 1):
                    output_layerh = output_layer1[0, 3 * j:3 * j + 3]
                    output_layerh.append(output_layerhidcont[j])  # adding output from context layer from previous iteration as input for hidden layer
                    input_layerhid[j] = model_1.input_method(output_layer1, model_1.weights_i[j, :])
                model_1.get_neuron_value(model_1.neuron_h, input_layerhid)  # feeding the neuron value of hidden layer
                output_layerhid = model_1.transfer_function(model_1.neuron_h)
                for i in range(0, 8, 1):
                    input_layerhidcont[i] = model_1.input_method(output_layerhid[i], model_1.weights_h_c[i])  # input function for hidden context layer, context layr only has one input to each neuron and one weight associated to each neuron
                model_1.get_neuron_value(model_1.neuron_h_c, input_layerhidcont)  # passing the input to the hidden context
                output_layerhidcont = model_1.transfer_frunction(model_1.neuron_h_c)  # output of the neurons from context layer
                input_layerout = tf.multiply(output_layerhid, model_1.weights_o[0:8])
                input_layerout.append(tf.multiply(output_layerhid, model_1.weights_o[8:16]))
                input_layerout.append(tf.multiply(output_layerhid, model_1.weights_o[16:24]))  # element wise multiplication
                model_1.get_neuron_value(model_1.neuron_o, input_layerout)
                output_layerout = model_1.output_function(model_1.neuron_o) # output of the neural network for model 1 that is to
                try:
                    talker('spider::joint_1_1', output_layerout[0])
                    talker('spider::joint_1_2', output_layerout[1])
                    talker('spider::joint_1_3', output_layerout[2])
                    talker('spider::joint_4_1', output_layerout[9])
                    talker('spider::joint_4_2', output_layerout[10])
                    talker('spider::joint_4_3', output_layerout[11])
                    talker('spider::joint_5_1', output_layerout[12])
                    talker('spider::joint_5_2', output_layerout[13])
                    talker('spider::joint_5_3', output_layerout[14])
                    talker('spider::joint_8_1', output_layerout[21])
                    talker('spider::joint_8_2', output_layerout[22])
                    talker('spider::joint_8_3', output_layerout[23])
                    talker('spider::joint_2_1', output_layerout[3])
                    talker('spider::joint_2_2', output_layerout[4])
                    talker('spider::joint_2_3', output_layerout[5])
                    talker('spider::joint_3_1', output_layerout[6])
                    talker('spider::joint_3_2', output_layerout[7])
                    talker('spider::joint_3_3', output_layerout[8])
                    talker('spider::joint_6_1', output_layerout[15])
                    talker('spider::joint_6_2', output_layerout[16])
                    talker('spider::joint_6_3', output_layerout[17])
                    talker('spider::joint_7_1', output_layerout[18])
                    talker('spider::joint_7_2', output_layerout[19])
                    talker('spider::joint_7_3', output_layerout[20])
                except rospy.ROSInterruptException:
                    pass
                rospy.spin()
            elif(model_trained == 2):
                model_2.get_neuron_value(model_2.neuron_i, joint_angle_input)
                for i in range(0, 24, 1):
                    output_layer1[i] = model_2.input_method(model_2.neuron_i[i, :], model_2.weight_in[:, i])  # finding the ouput of the input layer
                for j in range(0, 8, 1):
                    output_layerh = output_layer1[0, 3 * j:3 * j + 3]
                    output_layerh.append(output_layerhidcont[j])  # adding output from context layer from previous iteration as input for hidden layer
                    input_layerhid[j] = model_2.input_method(output_layer1, model_2.weights_i[j, :])
                model_2.get_neuron_value(model_2.neuron_h, input_layerhid)  # feeding the neuron value of hidden layer
                output_layerhid = model_2.transfer_function(model_2.neuron_h)
                for i in range(0, 8, 1):
                    input_layerhidcont[i] = model_2.input_method(output_layerhid[i], model_2.weights_h_c[i])  # input function for hidden context layer, context layr only has one input to each neuron and one weight associated to each neuron
                model_2.get_neuron_value(model_2.neuron_h_c, input_layerhidcont)  # passing the input to the hidden context
                output_layerhidcont = model_2.transfer_frunction(model_2.neuron_h_c)  # output of the neurons from context layer
                input_layerout = tf.multiply(output_layerhid, model_2.weights_o[0:8])
                input_layerout.append(tf.multiply(output_layerhid, model_2.weights_o[8:16]))
                input_layerout.append(tf.multiply(output_layerhid, model_2.weights_o[16:24]))  # element wise multiplication
                model_2.get_neuron_value(model_2.neuron_o, input_layerout)
                output_layerout = model_2.output_function(model_2.neuron_o)  # output of the neural network for model 1
                try:
                    talker('spider::joint_7_1', output_layerout[18])
                    talker('spider::joint_7_2', output_layerout[19])
                    talker('spider::joint_7_3', output_layerout[20])
                    talker('spider::joint_2_1', output_layerout[3])
                    talker('spider::joint_2_2', output_layerout[4])
                    talker('spider::joint_2_3', output_layerout[5])
                    talker('spider::joint_1_1', output_layerout[0])
                    talker('spider::joint_1_2', output_layerout[1])
                    talker('spider::joint_1_3', output_layerout[2])
                    talker('spider::joint_4_1', output_layerout[9])
                    talker('spider::joint_4_2', output_layerout[10])
                    talker('spider::joint_4_3', output_layerout[11])
                    talker('spider::joint_3_1', output_layerout[6])
                    talker('spider::joint_3_2', output_layerout[7])
                    talker('spider::joint_3_3', output_layerout[8])
                    talker('spider::joint_6_1', output_layerout[15])
                    talker('spider::joint_6_2', output_layerout[16])
                    talker('spider::joint_6_3', output_layerout[17])
                    talker('spider::joint_5_1', output_layerout[12])
                    talker('spider::joint_5_2', output_layerout[13])
                    talker('spider::joint_5_3', output_layerout[14])
                    talker('spider::joint_8_1', output_layerout[21])
                    talker('spider::joint_8_2', output_layerout[22])
                    talker('spider::joint_8_3', output_layerout[23])
                except rospy.ROSInterruptException:
                    pass
                rospy.spin()
            elif(model_trained == 3):
                model_3.get_neuron_value(model_3.neuron_i, joint_angle_input)
                for i in range(0, 24, 1):
                    output_layer1[i] = model_3.input_method(model_3.neuron_i[i, :], model_3.weight_in[:, i])  # finding the ouput of the input layer
                for j in range(0, 8, 1):
                    output_layerh = output_layer1[0, 3 * j:3 * j + 3]
                    output_layerh.append(output_layerhidcont[j])  # adding output from context layer from previous iteration as input for hidden layer
                    input_layerhid[j] = model_3.input_method(output_layer1, model_3.weights_i[j, :])
                model_3.get_neuron_value(model_3.neuron_h, input_layerhid)  # feeding the neuron value of hidden layer
                output_layerhid = model_3.transfer_function(model_3.neuron_h)
                for i in range(0, 8, 1):
                    input_layerhidcont[i] = model_3.input_method(output_layerhid[i], model_3.weights_h_c[i])  # input function for hidden context layer, context layr only has one input to each neuron and one weight associated to each neuron
                model_3.get_neuron_value(model_3.neuron_h_c, input_layerhidcont)  # passing the input to the hidden context
                output_layerhidcont = model_3.transfer_frunction(model_3.neuron_h_c)  # output of the neurons from context layer
                input_layerout = tf.multiply(output_layerhid, model_3.weights_o[0:8])
                input_layerout.append(tf.multiply(output_layerhid, model_3.weights_o[8:16]))
                input_layerout.append(tf.multiply(output_layerhid, model_3.weights_o[16:24]))  # element wise multiplication
                model_3.get_neuron_value(model_3.neuron_o, input_layerout)
                output_layerout = model_3.output_function(model_3.neuron_o)  # output of the neural network for model 1
                try:
                    talker('spider::joint_1_1', output_layerout[0])
                    talker('spider::joint_1_2', output_layerout[1])
                    talker('spider::joint_1_3', output_layerout[2])
                    talker('spider::joint_8_1', output_layerout[21])
                    talker('spider::joint_8_2', output_layerout[22])
                    talker('spider::joint_8_3', output_layerout[23])
                    talker('spider::joint_3_1', output_layerout[6])
                    talker('spider::joint_3_2', output_layerout[7])
                    talker('spider::joint_3_3', output_layerout[8])
                    talker('spider::joint_2_1', output_layerout[3])
                    talker('spider::joint_2_2', output_layerout[4])
                    talker('spider::joint_2_3', output_layerout[5])
                    talker('spider::joint_5_1', output_layerout[12])
                    talker('spider::joint_5_2', output_layerout[13])
                    talker('spider::joint_5_3', output_layerout[14])
                    talker('spider::joint_4_1', output_layerout[9])
                    talker('spider::joint_4_2', output_layerout[10])
                    talker('spider::joint_4_3', output_layerout[11])
                    talker('spider::joint_7_1', output_layerout[18])
                    talker('spider::joint_7_2', output_layerout[19])
                    talker('spider::joint_7_3', output_layerout[20])
                    talker('spider::joint_6_1', output_layerout[15])
                    talker('spider::joint_6_2', output_layerout[16])
                    talker('spider::joint_6_3', output_layerout[17])
                except rospy.ROSInterruptException:
                    pass
                rospy.spin()
            elif(model_trained == 4):
                model_4.get_neuron_value(model_4.neuron_i, joint_angle_input)
                for i in range(0, 24, 1):
                    output_layer1[i] = model_4.input_method(model_4.neuron_i[i, :], model_4.weight_in[:, i])  # finding the ouput of the input layer
                for j in range(0, 8, 1):
                    output_layerh = output_layer1[0, 3 * j:3 * j + 3]
                    output_layerh.append(output_layerhidcont[j])  # adding output from context layer from previous iteration as input for hidden layer
                    input_layerhid[j] = model_4.input_method(output_layer1, model_4.weights_i[j, :])
                model_4.get_neuron_value(model_4.neuron_h, input_layerhid)  # feeding the neuron value of hidden layer
                output_layerhid = model_4.transfer_function(model_4.neuron_h)
                for i in range(0, 8, 1):
                    input_layerhidcont[i] = model_4.input_method(output_layerhid[i], model_4.weights_h_c[i])  # input function for hidden context layer, context layr only has one input to each neuron and one weight associated to each neuron
                model_4.get_neuron_value(model_4.neuron_h_c, input_layerhidcont)  # passing the input to the hidden context
                output_layerhidcont = model_4.transfer_frunction(model_4.neuron_h_c)  # output of the neurons from context layer
                input_layerout = tf.multiply(output_layerhid, model_4.weights_o[0:8])
                input_layerout.append(tf.multiply(output_layerhid, model_4.weights_o[8:16]))
                input_layerout.append(tf.multiply(output_layerhid, model_4.weights_o[16:24]))  # element wise multiplication
                model_4.get_neuron_value(model_4.neuron_o, input_layerout)
                output_layerout = model_4.output_function(model_4.neuron_o)  # output of the neural network for model 1
                try:
                    talker('spider::joint_1_1', output_layerout[0])
                    talker('spider::joint_1_2', output_layerout[1])
                    talker('spider::joint_1_3', output_layerout[2])
                    talker('spider::joint_3_1', output_layerout[6])
                    talker('spider::joint_3_2', output_layerout[7])
                    talker('spider::joint_3_3', output_layerout[8])
                    talker('spider::joint_5_1', output_layerout[12])
                    talker('spider::joint_5_2', output_layerout[13])
                    talker('spider::joint_5_3', output_layerout[14])
                    talker('spider::joint_7_1', output_layerout[18])
                    talker('spider::joint_7_2', output_layerout[19])
                    talker('spider::joint_7_3', output_layerout[20])
                    talker('spider::joint_2_1', output_layerout[3])
                    talker('spider::joint_2_2', output_layerout[4])
                    talker('spider::joint_2_3', output_layerout[5])
                    talker('spider::joint_4_1', output_layerout[9])
                    talker('spider::joint_4_2', output_layerout[10])
                    talker('spider::joint_4_3', output_layerout[11])
                    talker('spider::joint_6_1', output_layerout[15])
                    talker('spider::joint_6_2', output_layerout[16])
                    talker('spider::joint_6_3', output_layerout[17])
                    talker('spider::joint_8_1', output_layerout[21])
                    talker('spider::joint_8_2', output_layerout[22])
                    talker('spider::joint_8_3', output_layerout[23])
                except rospy.ROSInterruptException:
                    pass
                rospy.spin()
            x_left_com = Leg_attribute.x_left_com(m, g, r, l, joint_angle_leg_1[0],
                                                  joint_angle_leg_1[1], joint_angle_leg_1[2], joint_angle_leg_2[0],
                                                  joint_angle_leg_2[1], joint_angle_leg_2[2], joint_angle_leg_3[0],
                                                  joint_angle_leg_3[1], joint_angle_leg_3[2], joint_angle_leg_4[0],
                                                  joint_angle_leg_4[1], joint_angle_leg_4[2], joint_angle_leg_5[0],
                                                  joint_angle_leg_5[1], joint_angle_leg_5[2], joint_angle_leg_6[0],
                                                  joint_angle_leg_6[1], joint_angle_leg_6[2], joint_angle_leg_7[0],
                                                  joint_angle_leg_7[1], joint_angle_leg_7[2], joint_angle_leg_8[0],
                                                  joint_angle_leg_8[1], joint_angle_leg_8[2])
            y_left_com = Leg_attribute.y_left_com(m, g, r, l, joint_angle_leg_1[0],
                                                  joint_angle_leg_1[1], joint_angle_leg_1[2], joint_angle_leg_2[0],
                                                  joint_angle_leg_2[1], joint_angle_leg_2[2], joint_angle_leg_3[0],
                                                  joint_angle_leg_3[1], joint_angle_leg_3[2], joint_angle_leg_4[0],
                                                  joint_angle_leg_4[1], joint_angle_leg_4[2], joint_angle_leg_5[0],
                                                  joint_angle_leg_5[1], joint_angle_leg_5[2], joint_angle_leg_6[0],
                                                  joint_angle_leg_6[1], joint_angle_leg_6[2], joint_angle_leg_7[0],
                                                  joint_angle_leg_7[1], joint_angle_leg_7[2], joint_angle_leg_8[0],
                                                  joint_angle_leg_8[1], joint_angle_leg_8[2])
            x_right_com = Leg_attribute.x_right_com(m, g, r, l, joint_angle_leg_1[0],
                                                    joint_angle_leg_1[1], joint_angle_leg_1[2], joint_angle_leg_2[0],
                                                    joint_angle_leg_2[1], joint_angle_leg_2[2], joint_angle_leg_3[0],
                                                    joint_angle_leg_3[1], joint_angle_leg_3[2], joint_angle_leg_4[0],
                                                    joint_angle_leg_4[1], joint_angle_leg_4[2], joint_angle_leg_5[0],
                                                    joint_angle_leg_5[1], joint_angle_leg_5[2], joint_angle_leg_6[0],
                                                    joint_angle_leg_6[1], joint_angle_leg_6[2], joint_angle_leg_7[0],
                                                    joint_angle_leg_7[1], joint_angle_leg_7[2], joint_angle_leg_8[0],
                                                    joint_angle_leg_8[1], joint_angle_leg_8[2])
            y_right_com = Leg_attribute.y_right_com(m, g, r, l, joint_angle_leg_1[0],
                                                    joint_angle_leg_1[1], joint_angle_leg_1[2], joint_angle_leg_2[0],
                                                    joint_angle_leg_2[1], joint_angle_leg_2[2], joint_angle_leg_3[0],
                                                    joint_angle_leg_3[1], joint_angle_leg_3[2], joint_angle_leg_4[0],
                                                    joint_angle_leg_4[1], joint_angle_leg_4[2], joint_angle_leg_5[0],
                                                    joint_angle_leg_5[1], joint_angle_leg_5[2], joint_angle_leg_6[0],
                                                    joint_angle_leg_6[1], joint_angle_leg_6[2], joint_angle_leg_7[0],
                                                    joint_angle_leg_7[1], joint_angle_leg_7[2], joint_angle_leg_8[0],
                                                    joint_angle_leg_8[1], joint_angle_leg_8[2])
            x_system_com = Leg_attribute.x_system_com(m, g, r, l, joint_angle_leg_1[0],
                                                      joint_angle_leg_1[1], joint_angle_leg_1[2], joint_angle_leg_2[0],
                                                      joint_angle_leg_2[1], joint_angle_leg_2[2], joint_angle_leg_3[0],
                                                      joint_angle_leg_3[1], joint_angle_leg_3[2], joint_angle_leg_4[0],
                                                      joint_angle_leg_4[1], joint_angle_leg_4[2], joint_angle_leg_5[0],
                                                      joint_angle_leg_5[1], joint_angle_leg_5[2], joint_angle_leg_6[0],
                                                      joint_angle_leg_6[1], joint_angle_leg_6[2], joint_angle_leg_7[0],
                                                      joint_angle_leg_7[1], joint_angle_leg_7[2], joint_angle_leg_8[0],
                                                      joint_angle_leg_8[1], joint_angle_leg_8[2])
            y_system_com = Leg_attribute.y_system_com(m, g, r, l, joint_angle_leg_1[0],
                                                      joint_angle_leg_1[1], joint_angle_leg_1[2], joint_angle_leg_2[0],
                                                      joint_angle_leg_2[1], joint_angle_leg_2[2], joint_angle_leg_3[0],
                                                      joint_angle_leg_3[1], joint_angle_leg_3[2], joint_angle_leg_4[0],
                                                      joint_angle_leg_4[1], joint_angle_leg_4[2], joint_angle_leg_5[0],
                                                      joint_angle_leg_5[1], joint_angle_leg_5[2], joint_angle_leg_6[0],
                                                      joint_angle_leg_6[1], joint_angle_leg_6[2], joint_angle_leg_7[0],
                                                      joint_angle_leg_7[1], joint_angle_leg_7[2], joint_angle_leg_8[0],
                                                      joint_angle_leg_8[1], joint_angle_leg_8[2])
            x_mid_com = Leg_attribute.mid_point_x(x_left_com, x_right_com)
            y_mid_com = Leg_attribute.mid_point_y(y_left_com, y_right_com)
            reward = prev_reward+ Leg_attribute.slope(x_mid_com, y_mid_com, x_system_com, y_system_com)
            Learningrate = 0.1
            model_1.NN_learningReward(Learningrate, reward)
            prev_reward = reward-balance_punishment#considering the punishment if robot happens to fall down
            leg1_carollis = leg_1.carolis_term(m, r, l, joint_angle_leg_1)
            leg2_carollis = leg_2.carolis_term(m, r, l, joint_angle_leg_2)
            leg3_carollis = leg_3.carolis_term(m, r, l, joint_angle_leg_3)
            leg4_carollis = leg_4.carolis_term(m, r, l, joint_angle_leg_4)
            leg5_carollis = leg_5.carolis_term(m, r, l, joint_angle_leg_5)
            leg6_carollis = leg_6.carolis_term(m, r, l, joint_angle_leg_6)
            leg7_carollis = leg_7.carolis_term(m, r, l, joint_angle_leg_7)
            leg8_carollis = leg_8.carolis_term(m, r, l, joint_angle_leg_8)
            carollis_input = np.array([leg1_carollis, leg2_carollis, leg3_carollis, leg4_carollis, leg5_carollis,
                                      leg6_carollis, leg7_carollis, leg8_carollis])
            normalization(carollis_input)
            knowledge_transfer.get_neuron(knowledge_transfer.neuron_input, carollis_input)
            'finding the output of the input layer'
            knowledge_input = knowledge_transfer.input_function(knowledge_transfer.neuron_input,
                                                                knowledge_transfer.weight_in,
                                                                knowledge_transfer.bias_in)
            'calculating the input for the hidden layer'
            tf.reshape(knowledge_input, [4, 2])
            knowledge_hidden = knowledge_transfer.input_method(knowledge_input, knowledge_transfer.weight_hid,
                                                               knowledge_transfer.bias_hid)
            'feeding in the input value of hidden neurons'
            knowledge_transfer.get_neuron(knowledge_transfer.neuron_hidden, knowledge_hidden)
            'calculating the output of hidden layer'
            knowledge_hidden_out = knowledge_transfer.activation(knowledge_transfer.neuron_hidden)
            'calculating the input of output layer'
            np.reshape(knowledge_hidden, [2, 2])
            extra = np.array(knowledge_hidden(1, 3), knowledge_hidden(2, 4))
            knowledge_out = tf.concat([knowledge_hidden, extra], axis=0)
            in_out = knowledge_transfer.input_method(knowledge_out, knowledge_transfer.weight_out, knowledge_transfer.bias_out)
            with tf.Session as s:
                s.run(in_out)
            'feeding the input value of output neurons'
            knowledge_transfer.get_neuron(knowledge_transfer.neuron_out, in_out)
            'finding the softmax output of the neurons'
            softmax_output = np.array(4)
            softmax_output = knowledge_transfer.out_softmax(knowledge_transfer.neuron_out)  # this gives the softmax output and stores it in the newly created array
            MultiClassLogistic.kt_learning(0.1, softmax_output, pref_out)


    elif ( run_method == 'test'):
        run_time = 1
    rospy.spin()
    joint_angles_input = np.array(24)
    output_layerhidcont = np.zeros(8, 1)
    while run_time:

        for spiderJoint1Name in spiderJoint1Names:
            (position, velocity, effort) = call_return_joint_states(spiderJoint1Name)
            leg1 = Leg_attribute(position, velocity, effort)

        for spiderJoint2Name in spiderJoint2Names:
            (position, velocity, effort) = call_return_joint_states(spiderJoint2Name)
            leg2 = Leg_attribute(position, velocity, effort)

        for spiderJoint3Name in spiderJoint3Names:
            (position, velocity, effort) = call_return_joint_states(spiderJoint3Name)
            leg3 = Leg_attribute(position, velocity, effort)

        for spiderJoint4Name in spiderJoint4Names:
            (position, velocity, effort) = call_return_joint_states(spiderJoint4Name)
            leg4 = Leg_attribute(position, velocity, effort)

        for spiderJoint5Name in spiderJoint5Names:
            (position, velocity, effort) = call_return_joint_states(spiderJoint5Name)
            leg5 = Leg_attribute(position, velocity, effort)

        for spiderJoint6Name in spiderJoint6Names:
            (position, velocity, effort) = call_return_joint_states(spiderJoint6Name)
            leg6 = Leg_attribute(position, velocity, effort)

        for spiderJoint7Name in spiderJoint7Names:
            (position, velocity, effort) = call_return_joint_states(spiderJoint7Name)
            leg7 = Leg_attribute(position, velocity, effort)

        for spiderJoint8Name in spiderJoint8Names:
            (position, velocity, effort) = call_return_joint_states(spiderJoint8Name)
            leg8 = Leg_attribute(position, velocity, effort)

        (tactile_1, tactile_2, tactile_3, tactile_4, tactile_5, tactile_6, tactile_7, tactile_8) = listener()
        not_touch = 0
        balance_punishment = 0
        if (tactile_1 == 0.0):
            not_touch += 1
        elif (tactile_2 == 0.0):
            not_touch += 1
        elif (tactile_3 == 0.0):
            not_touch += 1
        elif (tactile_3 == 0.0):
            not_touch += 1
        elif (tactile_4 == 0.0):
            not_touch += 1
        elif (tactile_5 == 0.0):
            not_touch += 1
        elif (tactile_6 == 0.0):
            not_touch += 1
        elif (tactile_7 == 0.0):
            not_touch += 1
        elif (tactile_8 == 0.0):
            not_touch += 1
        if (not_touch > 5):
            balance_punishment = 5
        joint_angle_leg_1 = leg1.give_angles() #writing the angles from each leg to a saperate array variable
        joint_angle_leg_2 = leg2.give_angles()
        joint_angle_leg_3 = leg3.give_angles()
        joint_angle_leg_4 = leg4.give_angles()
        joint_angle_leg_5 = leg5.give_angles()
        joint_angle_leg_6 = leg6.give_angles()
        joint_angle_leg_7 = leg7.give_angles()
        joint_angle_leg_8 = leg8.give_angles()
        joint_angles_input = np.concatenate(joint_angle_leg_1, joint_angle_leg_2, joint_angle_leg_3, joint_angle_leg_4, joint_angle_leg_5, joint_angle_leg_6, joint_angle_leg_7, joint_angle_leg_8)
        joint_angle_input = joint_angle_input.reshape(24, 1)#combined all the input angles into a single coloumn vector for a neural network
        model_1.get_neuron_value(model_1.neuron_i, joint_angle_input) #feeding the input angles into the input layer of the neural network
        output_layer1 = np.array(24)
        input_layerhid = np.array(8)
        output_layerhid = np.array(8)
        input_layerhidcont = np.array(8)
        output_layerhidcont = np.array(8)
        input_layerout = np.array(24)
        output_layerout  =np.array(24)
        for i in range(0, 24, 1):
            output_layer1[i] = model_1.input_method(model_1.neuron_i[i, :], weight_in[:, i])#finding the ouput of the input layer
        for j in range(0, 8, 1):
            output_layerh =  output_layer1[0, 3*j:3*j+3]
            output_layerh.append(output_layerhidcont[j])#adding output from context layer from previous iteration as input for hidden layer
            input_layerhid[j] = model_1.input_method(output_layer1, model_1.weights_i[j, :])
        model_1.get_neuron_value(model_1.neuron_h, input_layerhid)# feeding the neuron value of hidden layer
        output_layerhid = model_1.transfer_function(model_1.neuron_h)
        for i in range(0, 8, 1):
            input_layerhidcont[i] = model_1.input_method(output_layerhid[i],model_1.weights_h_c[i])#input function for hidden context layer, context layr only has one input to each neuron and one weight associated to each neuron
        model_1.get_neuron_value(model_1.neuron_h_c, input_layerhidcont)#passing the input to the hidden context
        output_layerhidcont = model_1.transfer_frunction(model_1.neuron_h_c)#output of the neurons from context layer
        input_layerout = tf.multiply(output_layerhid, model_1.weights_o[0:8])
        input_layerout.append(tf.multiply(output_layerhid, model_1.weights_o[8:16]))
        input_layerout.append(tf.multiply(output_layerhid, model_1.weights_o[16:24]))#element wise multiplication
        model_1.get_neuron_value(model_1.neuron_o, input_layerout)
        output_layerout1 = model_1.output_function(model_1.neuron_o)#output of the neural network for model 1 that is to be feeded to the robot
        'NN for model_2'
        for i in range(0, 24, 1):
            output_layer1[i] = model_2.input_method(model_2.neuron_i[i, :], model_2.weight_in[:, i])#finding the ouput of the input layer
        for j in range(0, 8, 1):
            output_layerh =  output_layer1[0, 3*j:3*j+3]
            output_layerh.append(output_layerhidcont[j])#adding output from context layer from previous iteration as input for hidden layer
            input_layerhid[j] = model_2.input_method(output_layer1, model_2.weights_i[j, :])
        model_2.get_neuron_value(model_2.neuron_h, input_layerhid)# feeding the neuron value of hidden layer
        output_layerhid = model_2.transfer_function(model_2.neuron_h)
        for i in range(0, 8, 1):
            input_layerhidcont[i] = model_2.input_method(output_layerhid[i],model_2.weights_h_c[i])#input function for hidden context layer, context layr only has one input to each neuron and one weight associated to each neuron
        model_2.get_neuron_value(model_2.neuron_h_c, input_layerhidcont)#passing the input to the hidden context
        output_layerhidcont = model_2.transfer_frunction(model_2.neuron_h_c)#output of the neurons from context layer
        input_layerout = tf.multiply(output_layerhid, model_2.weights_o[0:8])
        input_layerout.append(tf.multiply(output_layerhid, model_2.weights_o[8:16]))
        input_layerout.append(tf.multiply(output_layerhid, model_2.weights_o[16:24]))#element wise multiplication
        model_2.get_neuron_value(model_2.neuron_o, input_layerout)
        output_layerout2 = model_2.output_function(model_2.neuron_o)#output of the neural network for model 1 that is to
        'NN for model 3'
        for i in range(0, 24, 1):
            output_layer1[i] = model_3.input_method(model_3.neuron_i[i, :], weight_in[:, i])#finding the ouput of the input layer
        for j in range(0, 8, 1):
            output_layerh =  output_layer1[0, 3*j:3*j+3]
            output_layerh.append(output_layerhidcont[j])#adding output from context layer from previous iteration as input for hidden layer
            input_layerhid[j] = model_3.input_method(output_layer1, model_3.weights_i[j, :])
        model_3.get_neuron_value(model_3.neuron_h, input_layerhid)# feeding the neuron value of hidden layer
        output_layerhid = model_3.transfer_function(model_3.neuron_h)
        for i in range(0, 8, 1):
            input_layerhidcont[i] = model_3.input_method(output_layerhid[i],model_3.weights_h_c[i])#input function for hidden context layer, context layr only has one input to each neuron and one weight associated to each neuron
        model_3.get_neuron_value(model_3.neuron_h_c, input_layerhidcont)#passing the input to the hidden context
        output_layerhidcont = model_3.transfer_frunction(model_3.neuron_h_c)#output of the neurons from context layer
        input_layerout = tf.multiply(output_layerhid, model_3.weights_o[0:8])
        input_layerout.append(tf.multiply(output_layerhid, model_3.weights_o[8:16]))
        input_layerout.append(tf.multiply(output_layerhid, model_3.weights_o[16:24]))#element wise multiplication
        model_3.get_neuron_value(model_3.neuron_o, input_layerout)
        output_layerout3 = model_3.output_function(model_3.neuron_o)#output of the neural network for model 1 that is to
        'NN for model 4'
        for i in range(0, 24, 1):
            output_layer1[i] = model_4.input_method(model_4.neuron_i[i, :], model_4.weight_in[:, i])#finding the ouput of the input layer
        for j in range(0, 8, 1):
            output_layerh =  output_layer1[0, 3*j:3*j+3]
            output_layerh.append(output_layerhidcont[j])#adding output from context layer from previous iteration as input for hidden layer
            input_layerhid[j] = model_4.input_method(output_layer1, model_4.weights_i[j, :])
        model_4.get_neuron_value(model_1.neuron_h, input_layerhid)# feeding the neuron value of hidden layer
        output_layerhid = model_4.transfer_function(model_4.neuron_h)
        for i in range(0, 8, 1):
            input_layerhidcont[i] = model_4.input_method(output_layerhid[i],model_4.weights_h_c[i])#input function for hidden context layer, context layr only has one input to each neuron and one weight associated to each neuron
        model_4.get_neuron_value(model_4.neuron_h_c, input_layerhidcont)#passing the input to the hidden context
        output_layerhidcont = model_4.transfer_frunction(model_4.neuron_h_c)#output of the neurons from context layer
        input_layerout = tf.multiply(output_layerhid, model_4.weights_o[0:8])
        input_layerout.append(tf.multiply(output_layerhid, model_4.weights_o[8:16]))
        input_layerout.append(tf.multiply(output_layerhid, model_4.weights_o[16:24]))#element wise multiplication
        model_4.get_neuron_value(model_4.neuron_o, input_layerout)
        output_layerout4 = model_4.output_function(model_4.neuron_o)#output of the neural network for model 1 that is to
        'knowledge transfer algorithm starts here'
        leg1_carollis = leg1.carolis_term(leg1.m_l, leg1.r_1, leg1.l_1, joint_angle_leg_1)
        leg2_carollis = leg2.carolis_term(leg2.m_l, leg2.r_1, leg2.l_1, joint_angle_leg_2)
        leg3_carollis = leg3.carolis_term(leg3.m_l, leg3.r_1, leg3.l_1, joint_angle_leg_3)
        leg4_carollis = leg4.carolis_term(leg4.m_l, leg4.r_1, leg4.l_1, joint_angle_leg_4)
        leg5_carollis = leg5.carolis_term(leg5.m_l, leg5.r_1, leg5.l_1, joint_angle_leg_5)
        leg6_carollis = leg6.carolis_term(leg6.m_l, leg6.r_1, leg6.l_1, joint_angle_leg_6)
        leg7_carollis = leg7.carolis_term(leg7.m_l, leg7.r_1, leg7.l_1, joint_angle_leg_7)
        leg8_carollis = leg8.carolis_term(leg8.m_l, leg8.r_1, leg8.l_1, joint_angle_leg_8)
        carollis_input = np.array([leg1_carollis, leg2_carollis, leg3_carollis, leg4_carollis, leg5_carollis, leg6_carollis, leg7_carollis, leg8_carollis])
        normalization(carollis_input)
        knowledge_transfer.get_neuron(knowledge_transfer.neuron_input, carollis_input)
        'finding the output of the input layer'
        knowledge_input = knowledge_transfer.input_function(knowledge_transfer.neuron_input, knowledge_transfer.weight_in, knowledge_transfer.bias_in)
        'calculating the input for the hidden layer'
        tf.reshape(knowledge_input, [4, 2])
        knowledge_hidden = knowledge_transfer.input_method(knowledge_input, knowledge_transfer.weight_hid, knowledge_transfer.bias_hid)
        'feeding in the input value of hidden neurons'
        knowledge_transfer.get_neuron(knowledge_transfer.neuron_hidden, knowledge_hidden)
        'calculating the output of hidden layer'
        knowledge_hidden_out = knowledge_transfer.activation(knowledge_transfer.neuron_hidden)
        'calculating the input of output layer'
        np.reshape(knowledge_hidden, [2, 2])
        extra = np.array(knowledge_hidden(1, 3), knowledge_hidden(2, 4))
        knowledge_out = tf.concat([knowledge_hidden, extra], axis=0)
        in_out = knowledge_transfer.input_method(knowledge_out, knowledge_transfer.weight_out, knowledge_transfer.bias_out)
        with tf.Session as s:
            s.run(in_out)
        'feeding the input value of output neurons'
        knowledge_transfer.get_neuron(knowledge_transfer.neuron_out, in_out)
        'finding the softmax output of the neurons'
        #softmax_output = np.array(4)
        softmax_output = knowledge_transfer.out_softmax(knowledge_transfer.neuron_out)#this gives the softmax output and stores it in the newly created array
        model = max(softmax_output)
        if (softmax_output[0] == model):
            try:
                talker('spider::joint_1_1', output_layerout1[0])
                talker('spider::joint_1_2', output_layerout1[1])
                talker('spider::joint_1_3', output_layerout1[2])
                talker('spider::joint_4_1', output_layerout1[9])
                talker('spider::joint_4_2', output_layerout1[10])
                talker('spider::joint_4_3', output_layerout1[11])
                talker('spider::joint_5_1', output_layerout1[12])
                talker('spider::joint_5_2', output_layerout1[13])
                talker('spider::joint_5_3', output_layerout1[14])
                talker('spider::joint_8_1', output_layerout1[21])
                talker('spider::joint_8_2', output_layerout1[22])
                talker('spider::joint_8_3', output_layerout1[23])
                talker('spider::joint_2_1', output_layerout1[3])
                talker('spider::joint_2_2', output_layerout1[4])
                talker('spider::joint_2_3', output_layerout1[5])
                talker('spider::joint_3_1', output_layerout1[6])
                talker('spider::joint_3_2', output_layerout1[7])
                talker('spider::joint_3_3', output_layerout1[8])
                talker('spider::joint_6_1', output_layerout1[15])
                talker('spider::joint_6_2', output_layerout1[16])
                talker('spider::joint_6_3', output_layerout1[17])
                talker('spider::joint_7_1', output_layerout1[18])
                talker('spider::joint_7_2', output_layerout1[19])
                talker('spider::joint_7_3', output_layerout1[20])
                x_left_com = Leg_attribute.x_left_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout1[0],
                                                          output_layerout1[1], output_layerout1[2], output_layerout1[3],
                                                          output_layerout1[4], output_layerout1[5], output_layerout1[6],
                                                          output_layerout1[7], output_layerout1[8], output_layerout1[9],
                                                          output_layerout1[10], output_layerout1[11],
                                                          output_layerout1[12], output_layerout1[13],
                                                          output_layerout1[14], output_layerout1[15],
                                                          output_layerout1[16], output_layerout1[17],
                                                          output_layerout1[18], output_layerout1[19],
                                                          output_layerout1[20], output_layerout1[21],
                                                          output_layerout1[22], output_layerout1[23])
                y_left_com = Leg_attribute.y_left_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout1[0],
                                                          output_layerout1[1], output_layerout1[2], output_layerout1[3],
                                                          output_layerout1[4], output_layerout1[5], output_layerout1[6],
                                                          output_layerout1[7], output_layerout1[8], output_layerout1[9],
                                                          output_layerout1[10], output_layerout1[11],
                                                          output_layerout1[12], output_layerout1[13],
                                                          output_layerout1[14], output_layerout1[15],
                                                          output_layerout1[16], output_layerout1[17],
                                                          output_layerout1[18], output_layerout1[19],
                                                          output_layerout1[20], output_layerout1[21],
                                                          output_layerout1[22], output_layerout1[23])
                x_right_com = Leg_attribute.x_right_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout1[0],
                                                          output_layerout1[1], output_layerout1[2], output_layerout1[3],
                                                          output_layerout1[4], output_layerout1[5], output_layerout1[6],
                                                          output_layerout1[7], output_layerout1[8], output_layerout1[9],
                                                          output_layerout1[10], output_layerout1[11],
                                                          output_layerout1[12], output_layerout1[13],
                                                          output_layerout1[14], output_layerout1[15],
                                                          output_layerout1[16], output_layerout1[17],
                                                          output_layerout1[18], output_layerout1[19],
                                                          output_layerout1[20], output_layerout1[21],
                                                          output_layerout1[22], output_layerout1[23])
                y_right_com = Leg_attribute.y_right_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout1[0],
                                                          output_layerout1[1], output_layerout1[2], output_layerout1[3],
                                                          output_layerout1[4], output_layerout1[5], output_layerout1[6],
                                                          output_layerout1[7], output_layerout1[8], output_layerout1[9],
                                                          output_layerout1[10], output_layerout1[11],
                                                          output_layerout1[12], output_layerout1[13],
                                                          output_layerout1[14], output_layerout1[15],
                                                          output_layerout1[16], output_layerout1[17],
                                                          output_layerout1[18], output_layerout1[19],
                                                          output_layerout1[20], output_layerout1[21],
                                                          output_layerout1[22], output_layerout1[23])
                x_system_com = Leg_attribute.x_system_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout1[0],
                                                          output_layerout1[1], output_layerout1[2], output_layerout1[3],
                                                          output_layerout1[4], output_layerout1[5], output_layerout1[6],
                                                          output_layerout1[7], output_layerout1[8], output_layerout1[9],
                                                          output_layerout1[10], output_layerout1[11],
                                                          output_layerout1[12], output_layerout1[13],
                                                          output_layerout1[14], output_layerout1[15],
                                                          output_layerout1[16], output_layerout1[17],
                                                          output_layerout1[18], output_layerout1[19],
                                                          output_layerout1[20], output_layerout1[21],
                                                          output_layerout1[22], output_layerout1[23])
                y_system_com = Leg_attribute.y_system_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout1[0],
                                                          output_layerout1[1], output_layerout1[2], output_layerout1[3],
                                                          output_layerout1[4], output_layerout1[5], output_layerout1[6],
                                                          output_layerout1[7], output_layerout1[8], output_layerout1[9],
                                                          output_layerout1[10], output_layerout1[11],
                                                          output_layerout1[12], output_layerout1[13],
                                                          output_layerout1[14], output_layerout1[15],
                                                          output_layerout1[16], output_layerout1[17],
                                                          output_layerout1[18], output_layerout1[19],
                                                          output_layerout1[20], output_layerout1[21],
                                                          output_layerout1[22], output_layerout1[23])
                x_mid_com = Leg_attribute.mid_point_x(x_left_com, x_right_com)
                y_mid_com = Leg_attribute.mid_point_y(y_left_com, y_right_com)
                reward = prev_reward+ Leg_attribute.slope(x_mid_com, y_mid_com, x_system_com, y_system_com)
                np.append(reward_history, [reward], axis=0)
                Learningrate = 0.1
                model_1.NN_learningReward(Learningrate, reward)
                prev_reward = reward+ balance_punishment
            except rospy.ROSInterruptException:
                pass
            rospy.spin()
        elif (softmax_output[1] == model):
            try:
                talker('spider::joint_7_1', output_layerout2[18])
                talker('spider::joint_7_2', output_layerout2[19])
                talker('spider::joint_7_3', output_layerout2[20])
                talker('spider::joint_2_1', output_layerout2[3])
                talker('spider::joint_2_2', output_layerout2[4])
                talker('spider::joint_2_3', output_layerout2[5])
                talker('spider::joint_1_1', output_layerout2[0])
                talker('spider::joint_1_2', output_layerout2[1])
                talker('spider::joint_1_3', output_layerout2[2])
                talker('spider::joint_4_1', output_layerout2[9])
                talker('spider::joint_4_2', output_layerout2[10])
                talker('spider::joint_4_3', output_layerout2[11])
                talker('spider::joint_3_1', output_layerout2[6])
                talker('spider::joint_3_2', output_layerout2[7])
                talker('spider::joint_3_3', output_layerout2[8])
                talker('spider::joint_6_1', output_layerout2[15])
                talker('spider::joint_6_2', output_layerout2[16])
                talker('spider::joint_6_3', output_layerout2[17])
                talker('spider::joint_5_1', output_layerout2[12])
                talker('spider::joint_5_2', output_layerout2[13])
                talker('spider::joint_5_3', output_layerout2[14])
                talker('spider::joint_8_1', output_layerout2[21])
                talker('spider::joint_8_2', output_layerout2[22])
                talker('spider::joint_8_3', output_layerout2[23])
                x_left_com = Leg_attribute.x_left_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout2[0],
                                                          output_layerout2[1], output_layerout2[2], output_layerout2[3],
                                                          output_layerout2[4], output_layerout2[5], output_layerout2[6],
                                                          output_layerout2[7], output_layerout2[8], output_layerout2[9],
                                                          output_layerout2[10], output_layerout2[11],
                                                          output_layerout2[12], output_layerout2[13],
                                                          output_layerout2[14], output_layerout2[15],
                                                          output_layerout2[16], output_layerout2[17],
                                                          output_layerout2[18], output_layerout2[19],
                                                          output_layerout2[20], output_layerout2[21],
                                                          output_layerout2[22], output_layerout2[23])
                y_left_com = Leg_attribute.y_left_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout2[0],
                                                          output_layerout2[1], output_layerout2[2], output_layerout2[3],
                                                          output_layerout2[4], output_layerout2[5], output_layerout2[6],
                                                          output_layerout2[7], output_layerout2[8], output_layerout2[9],
                                                          output_layerout2[10], output_layerout2[11],
                                                          output_layerout2[12], output_layerout2[13],
                                                          output_layerout2[14], output_layerout2[15],
                                                          output_layerout2[16], output_layerout2[17],
                                                          output_layerout2[18], output_layerout2[19],
                                                          output_layerout2[20], output_layerout2[21],
                                                          output_layerout2[22], output_layerout2[23])
                x_right_com = Leg_attribute.x_right_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout2[0],
                                                          output_layerout2[1], output_layerout2[2], output_layerout2[3],
                                                          output_layerout2[4], output_layerout2[5], output_layerout2[6],
                                                          output_layerout2[7], output_layerout2[8], output_layerout2[9],
                                                          output_layerout2[10], output_layerout2[11],
                                                          output_layerout2[12], output_layerout2[13],
                                                          output_layerout2[14], output_layerout2[15],
                                                          output_layerout2[16], output_layerout2[17],
                                                          output_layerout2[18], output_layerout2[19],
                                                          output_layerout2[20], output_layerout2[21],
                                                          output_layerout2[22], output_layerout2[23])
                y_right_com = Leg_attribute.y_right_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout2[0],
                                                          output_layerout2[1], output_layerout2[2], output_layerout2[3],
                                                          output_layerout2[4], output_layerout2[5], output_layerout2[6],
                                                          output_layerout2[7], output_layerout2[8], output_layerout2[9],
                                                          output_layerout2[10], output_layerout2[11],
                                                          output_layerout2[12], output_layerout2[13],
                                                          output_layerout2[14], output_layerout2[15],
                                                          output_layerout2[16], output_layerout2[17],
                                                          output_layerout2[18], output_layerout2[19],
                                                          output_layerout2[20], output_layerout2[21],
                                                          output_layerout2[22], output_layerout2[23])
                x_system_com = Leg_attribute.x_system_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout2[0],
                                                          output_layerout2[1], output_layerout2[2], output_layerout2[3],
                                                          output_layerout2[4], output_layerout2[5], output_layerout2[6],
                                                          output_layerout2[7], output_layerout2[8], output_layerout2[9],
                                                          output_layerout2[10], output_layerout2[11],
                                                          output_layerout2[12], output_layerout2[13],
                                                          output_layerout2[14], output_layerout2[15],
                                                          output_layerout2[16], output_layerout2[17],
                                                          output_layerout2[18], output_layerout2[19],
                                                          output_layerout2[20], output_layerout2[21],
                                                          output_layerout2[22], output_layerout2[23])
                y_system_com = Leg_attribute.y_system_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout2[0],
                                                          output_layerout2[1], output_layerout2[2], output_layerout2[3],
                                                          output_layerout2[4], output_layerout2[5], output_layerout2[6],
                                                          output_layerout2[7], output_layerout2[8], output_layerout2[9],
                                                          output_layerout2[10], output_layerout2[11],
                                                          output_layerout2[12], output_layerout2[13],
                                                          output_layerout2[14], output_layerout2[15],
                                                          output_layerout2[16], output_layerout2[17],
                                                          output_layerout2[18], output_layerout2[19],
                                                          output_layerout2[20], output_layerout2[21],
                                                          output_layerout2[22], output_layerout2[23])
                x_mid_com = Leg_attribute.mid_point_x(x_left_com, x_right_com)
                y_mid_com = Leg_attribute.mid_point_y(y_left_com, y_right_com)
                reward = prev_reward+Leg_attribute.slope(x_mid_com, y_mid_com, x_system_com, y_system_com)
                np.append(reward_history, [reward], axis=0)
                Learningrate = 0.1
                model_1.NN_learningReward(Learningrate, reward)
                prev_reward = reward+balance_punishment
            except rospy.ROSInterruptException:
                pass
            rospy.spin()
        elif (softmax_output[2] == model):
            try:
                talker('spider::joint_1_1', output_layerout3[0])
                talker('spider::joint_1_2', output_layerout3[1])
                talker('spider::joint_1_3', output_layerout3[2])
                talker('spider::joint_8_1', output_layerout3[21])
                talker('spider::joint_8_2', output_layerout3[22])
                talker('spider::joint_8_3', output_layerout3[23])
                talker('spider::joint_3_1', output_layerout3[6])
                talker('spider::joint_3_2', output_layerout3[7])
                talker('spider::joint_3_3', output_layerout3[8])
                talker('spider::joint_2_1', output_layerout3[3])
                talker('spider::joint_2_2', output_layerout3[4])
                talker('spider::joint_2_3', output_layerout3[5])
                talker('spider::joint_5_1', output_layerout3[12])
                talker('spider::joint_5_2', output_layerout3[13])
                talker('spider::joint_5_3', output_layerout3[14])
                talker('spider::joint_4_1', output_layerout3[9])
                talker('spider::joint_4_2', output_layerout3[10])
                talker('spider::joint_4_3', output_layerout3[11])
                talker('spider::joint_7_1', output_layerout3[18])
                talker('spider::joint_7_2', output_layerout3[19])
                talker('spider::joint_7_3', output_layerout3[20])
                talker('spider::joint_6_1', output_layerout3[15])
                talker('spider::joint_6_2', output_layerout3[16])
                talker('spider::joint_6_3', output_layerout3[17])
                x_left_com = Leg_attribute.x_left_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout3[0],
                                                      output_layerout3[1], output_layerout3[2], output_layerout3[3],
                                                      output_layerout3[4], output_layerout3[5], output_layerout3[6],
                                                      output_layerout3[7], output_layerout3[8], output_layerout3[9],
                                                      output_layerout3[10], output_layerout3[11], output_layerout3[12],
                                                      output_layerout3[13], output_layerout3[14], output_layerout3[15],
                                                      output_layerout3[16], output_layerout3[17], output_layerout3[18],
                                                      output_layerout3[19], output_layerout3[20], output_layerout3[21],
                                                      output_layerout3[22], output_layerout3[23])
                y_left_com = Leg_attribute.y_left_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout3[0],
                                                      output_layerout3[1], output_layerout3[2], output_layerout3[3],
                                                      output_layerout3[4], output_layerout3[5], output_layerout3[6],
                                                      output_layerout3[7], output_layerout3[8], output_layerout3[9],
                                                      output_layerout3[10], output_layerout3[11], output_layerout3[12],
                                                      output_layerout3[13], output_layerout3[14], output_layerout3[15],
                                                      output_layerout3[16], output_layerout3[17], output_layerout3[18],
                                                      output_layerout3[19], output_layerout3[20], output_layerout3[21],
                                                      output_layerout3[22], output_layerout3[23])
                x_right_com = Leg_attribute.x_right_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout3[0],
                                                        output_layerout3[1], output_layerout3[2], output_layerout3[3],
                                                        output_layerout3[4], output_layerout3[5], output_layerout3[6],
                                                        output_layerout3[7], output_layerout3[8], output_layerout3[9],
                                                        output_layerout3[10], output_layerout3[11],
                                                        output_layerout3[12], output_layerout3[13],
                                                        output_layerout3[14], output_layerout3[15],
                                                        output_layerout3[16], output_layerout3[17],
                                                        output_layerout3[18], output_layerout3[19],
                                                        output_layerout3[20], output_layerout3[21],
                                                        output_layerout3[22], output_layerout3[23])
                y_right_com = Leg_attribute.y_right_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout3[0],
                                                        output_layerout3[1], output_layerout3[2], output_layerout3[3],
                                                        output_layerout3[4], output_layerout3[5], output_layerout3[6],
                                                        output_layerout3[7], output_layerout3[8], output_layerout3[9],
                                                        output_layerout3[10], output_layerout3[11],
                                                        output_layerout3[12], output_layerout3[13],
                                                        output_layerout3[14], output_layerout3[15],
                                                        output_layerout3[16], output_layerout3[17],
                                                        output_layerout3[18], output_layerout3[19],
                                                        output_layerout3[20], output_layerout3[21],
                                                        output_layerout3[22], output_layerout3[23])
                x_system_com = Leg_attribute.x_system_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout3[0],
                                                          output_layerout3[1], output_layerout3[2], output_layerout3[3],
                                                          output_layerout3[4], output_layerout3[5], output_layerout3[6],
                                                          output_layerout3[7], output_layerout3[8], output_layerout3[9],
                                                          output_layerout3[10], output_layerout3[11],
                                                          output_layerout3[12], output_layerout3[13],
                                                          output_layerout3[14], output_layerout3[15],
                                                          output_layerout3[16], output_layerout3[17],
                                                          output_layerout3[18], output_layerout3[19],
                                                          output_layerout3[20], output_layerout3[21],
                                                          output_layerout3[22], output_layerout3[23])
                y_system_com = Leg_attribute.y_system_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout3[0],
                                                          output_layerout3[1], output_layerout3[2], output_layerout3[3],
                                                          output_layerout3[4], output_layerout3[5], output_layerout3[6],
                                                          output_layerout3[7], output_layerout3[8], output_layerout3[9],
                                                          output_layerout3[10], output_layerout3[11],
                                                          output_layerout3[12], output_layerout3[13],
                                                          output_layerout3[14], output_layerout3[15],
                                                          output_layerout3[16], output_layerout3[17],
                                                          output_layerout3[18], output_layerout3[19],
                                                          output_layerout3[20], output_layerout3[21],
                                                          output_layerout3[22], output_layerout3[23])
                x_mid_com = Leg_attribute.mid_point_x(x_left_com, x_right_com)
                y_mid_com = Leg_attribute.mid_point_y(y_left_com, y_right_com)
                reward = prev_reward + Leg_attribute.slope(x_mid_com, y_mid_com, x_system_com, y_system_com)
                np.append(reward_history, [reward], axis=0)
                Learningrate = 0.1
                model_1.NN_learningReward(Learningrate, reward)
                prev_reward  =reward+balance_punishment
            except rospy.ROSInterruptException:
                pass
            rospy.spin()
        elif (softmax_output[3] == model):
            try:
                talker('spider::joint_1_1', output_layerout4[0])
                talker('spider::joint_1_2', output_layerout4[1])
                talker('spider::joint_1_3', output_layerout4[2])
                talker('spider::joint_3_1', output_layerout4[6])
                talker('spider::joint_3_2', output_layerout4[7])
                talker('spider::joint_3_3', output_layerout4[8])
                talker('spider::joint_5_1', output_layerout4[12])
                talker('spider::joint_5_2', output_layerout4[13])
                talker('spider::joint_5_3', output_layerout4[14])
                talker('spider::joint_7_1', output_layerout4[18])
                talker('spider::joint_7_2', output_layerout4[19])
                talker('spider::joint_7_3', output_layerout4[20])
                talker('spider::joint_2_1', output_layerout4[3])
                talker('spider::joint_2_2', output_layerout4[4])
                talker('spider::joint_2_3', output_layerout4[5])
                talker('spider::joint_4_1', output_layerout4[9])
                talker('spider::joint_4_2', output_layerout4[10])
                talker('spider::joint_4_3', output_layerout4[11])
                talker('spider::joint_6_1', output_layerout4[15])
                talker('spider::joint_6_2', output_layerout4[16])
                talker('spider::joint_6_3', output_layerout4[17])
                talker('spider::joint_8_1', output_layerout4[21])
                talker('spider::joint_8_2', output_layerout4[22])
                talker('spider::joint_8_3', output_layerout4[23])
                x_left_com = Leg_attribute.x_left_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout4[0],
                                                      output_layerout4[1], output_layerout4[2], output_layerout4[3],
                                                      output_layerout4[4], output_layerout4[5], output_layerout4[6],
                                                      output_layerout4[7], output_layerout4[8], output_layerout4[9],
                                                      output_layerout4[10], output_layerout4[11], output_layerout4[12],
                                                      output_layerout4[13], output_layerout4[14], output_layerout4[15],
                                                      output_layerout4[16], output_layerout4[17], output_layerout4[18],
                                                      output_layerout4[19], output_layerout4[20], output_layerout4[21],
                                                      output_layerout4[22], output_layerout4[23])
                y_left_com = Leg_attribute.y_left_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout4[0],
                                                      output_layerout4[1], output_layerout4[2], output_layerout4[3],
                                                      output_layerout4[4], output_layerout4[5], output_layerout4[6],
                                                      output_layerout4[7], output_layerout4[8], output_layerout4[9],
                                                      output_layerout4[10], output_layerout4[11], output_layerout4[12],
                                                      output_layerout4[13], output_layerout4[14], output_layerout4[15],
                                                      output_layerout4[16], output_layerout4[17], output_layerout4[18],
                                                      output_layerout4[19], output_layerout4[20], output_layerout4[21],
                                                      output_layerout4[22], output_layerout4[23])
                x_right_com = Leg_attribute.x_right_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout4[0],
                                                        output_layerout4[1], output_layerout4[2], output_layerout4[3],
                                                        output_layerout4[4], output_layerout4[5], output_layerout4[6],
                                                        output_layerout4[7], output_layerout4[8], output_layerout4[9],
                                                        output_layerout4[10], output_layerout4[11],
                                                        output_layerout4[12], output_layerout4[13],
                                                        output_layerout4[14], output_layerout4[15],
                                                        output_layerout4[16], output_layerout4[17],
                                                        output_layerout4[18], output_layerout4[19],
                                                        output_layerout4[20], output_layerout4[21],
                                                        output_layerout4[22], output_layerout4[23])
                y_right_com = Leg_attribute.y_right_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout4[0],
                                                        output_layerout4[1], output_layerout4[2], output_layerout4[3],
                                                        output_layerout4[4], output_layerout4[5], output_layerout4[6],
                                                        output_layerout4[7], output_layerout4[8], output_layerout4[9],
                                                        output_layerout4[10], output_layerout4[11],
                                                        output_layerout4[12], output_layerout4[13],
                                                        output_layerout4[14], output_layerout4[15],
                                                        output_layerout4[16], output_layerout4[17],
                                                        output_layerout4[18], output_layerout4[19],
                                                        output_layerout4[20], output_layerout4[21],
                                                        output_layerout4[22], output_layerout4[23])
                x_system_com = Leg_attribute.x_system_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout4[0],
                                                          output_layerout4[1], output_layerout4[2], output_layerout4[3],
                                                          output_layerout4[4], output_layerout4[5], output_layerout4[6],
                                                          output_layerout4[7], output_layerout4[8], output_layerout4[9],
                                                          output_layerout4[10], output_layerout4[11],
                                                          output_layerout4[12], output_layerout4[13],
                                                          output_layerout4[14], output_layerout4[15],
                                                          output_layerout4[16], output_layerout4[17],
                                                          output_layerout4[18], output_layerout4[19],
                                                          output_layerout4[20], output_layerout4[21],
                                                          output_layerout4[22], output_layerout4[23])
                y_system_com = Leg_attribute.y_system_com(leg1.m_l, g, leg1.r_1, leg1.l_1, output_layerout4[0],
                                                          output_layerout4[1], output_layerout4[2], output_layerout4[3],
                                                          output_layerout4[4], output_layerout4[5], output_layerout4[6],
                                                          output_layerout4[7], output_layerout4[8], output_layerout4[9],
                                                          output_layerout4[10], output_layerout4[11],
                                                          output_layerout4[12], output_layerout4[13],
                                                          output_layerout4[14], output_layerout4[15],
                                                          output_layerout4[16], output_layerout4[17],
                                                          output_layerout4[18], output_layerout4[19],
                                                          output_layerout4[20], output_layerout4[21],
                                                          output_layerout4[22], output_layerout4[23])
                x_mid_com = Leg_attribute.mid_point_x(x_left_com, x_right_com)
                y_mid_com = Leg_attribute.mid_point_y(y_left_com, y_right_com)
                reward = prev_reward+Leg_attribute.slope(x_mid_com, y_mid_com, x_system_com, y_system_com)
                np.append(reward_history, [reward], axis=0)
                Learningrate = 0.1
                model_1.NN_learningReward(Learningrate, reward)
                prev_reward = reward+balance_punishment
            except rospy.ROSInterruptException:
                pass
            rospy.spin()

















